<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class DailySale extends Model
{
    protected $fillable = [
        'date',
        'invoice_number',
        'customer_name',
        'customer_phone',
        'customer_address',
        'total_tp',
        'total_dp',
        'total_profit',
        'due_amount',
        'paid_amount',
        'discount',
        'net_profit',
    ];

    protected $casts = [
        'date' => 'date',
        'total_tp' => 'decimal:2',
        'total_dp' => 'decimal:2',
        'total_profit' => 'decimal:2',
        'due_amount' => 'decimal:2',
        'paid_amount' => 'decimal:2',
        'discount' => 'decimal:2',
        'net_profit' => 'decimal:2',
    ];

    public function items(): HasMany
    {
        return $this->hasMany(DailySaleItem::class);
    }
}
