<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DailySaleItem extends Model
{
    protected $fillable = [
        'daily_sale_id',
        'item_name',
        'qty',
        'dp',
        'tp',
        'total_tp',
        'total_dp',
        'profit',
    ];

    protected $casts = [
        'daily_sale_id' => 'integer',
        'qty' => 'integer',
        'dp' => 'decimal:2',
        'tp' => 'decimal:2',
        'total_tp' => 'decimal:2',
        'total_dp' => 'decimal:2',
        'profit' => 'decimal:2',
    ];

    public function dailySale(): BelongsTo
    {
        return $this->belongsTo(DailySale::class);
    }
}
