<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_items', function (Blueprint $table) {
            $table->id();
            $table->string('item_name');
            $table->string('vendor')->nullable();
            $table->date('stock_in_date');
            $table->integer('stock_in_qty')->default(0);
            $table->date('stock_out_date')->nullable();
            $table->integer('stock_out_qty')->default(0);
            $table->decimal('cost_price', 10, 2);
            $table->integer('stock_balance')->default(0);
            $table->decimal('selling_price', 10, 2);
            $table->decimal('total_sales_rate', 12, 2)->default(0.00);
            $table->decimal('total_stock_rate', 12, 2)->default(0.00);
            $table->timestamps();

            $table->index('item_name');
            $table->index('stock_balance');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_items');
    }
};
