<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('daily_sale_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('daily_sale_id')->constrained()->onDelete('cascade');
            $table->string('item_name');
            $table->integer('qty');
            $table->decimal('dp', 10, 2);
            $table->decimal('tp', 10, 2);
            $table->decimal('total_tp', 12, 2);
            $table->decimal('total_dp', 12, 2);
            $table->decimal('profit', 12, 2);
            $table->timestamps();

            $table->index('daily_sale_id');
            $table->index('item_name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('daily_sale_items');
    }
};
