<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\DashboardService;

class DashboardController extends Controller
{
    public function __construct(private DashboardService $dashboardService)
    {
    }

    public function stats()
    {
        return response()->json($this->dashboardService->getStats());
    }

    public function salesTrend()
    {
        return response()->json($this->dashboardService->getSalesTrend());
    }

    public function topProducts()
    {
        return response()->json($this->dashboardService->getTopProducts());
    }

    public function categoryDistribution()
    {
        return response()->json($this->dashboardService->getCategoryDistribution());
    }
}
