import { Leaf } from "lucide-react";

const InvoicePreview = () => {
  return (
    <div className="glass-card rounded-xl animate-fade-in" style={{ animationDelay: "200ms" }}>
      <div className="p-5 border-b border-border">
        <h3 className="text-lg font-bold font-display text-foreground">Invoice Template</h3>
        <p className="text-sm text-muted-foreground mt-1">Sample invoice format for Nagar Gram Service</p>
      </div>
      <div className="p-6">
        <div className="border border-border rounded-xl p-6 bg-card max-w-2xl mx-auto">
          {/* Invoice Header */}
          <div className="flex items-start justify-between mb-6 pb-4 border-b border-border">
            <div className="flex items-center gap-3">
              <div className="bg-primary rounded-lg p-2">
                <Leaf className="h-5 w-5 text-primary-foreground" />
              </div>
              <div>
                <h2 className="text-xl font-bold font-display text-foreground">Nagar Gram Service</h2>
                <p className="text-xs text-muted-foreground">Professor Para Mor, Noapara, Jessore</p>
              </div>
            </div>
            <div className="text-right">
              <h3 className="text-lg font-bold font-display text-primary">INVOICE</h3>
              <p className="text-xs text-muted-foreground">Bill No: #001</p>
              <p className="text-xs text-muted-foreground">Date: 15/01/2026</p>
            </div>
          </div>

          {/* Customer Info */}
          <div className="grid grid-cols-2 gap-4 mb-6 text-sm">
            <div>
              <p className="text-xs text-muted-foreground font-semibold mb-1">Bill To:</p>
              <p className="text-foreground font-medium">Customer Name</p>
              <p className="text-muted-foreground text-xs">Customer Address</p>
              <p className="text-muted-foreground text-xs">Mobile: 01XXXXXXXXX</p>
            </div>
            <div className="text-right">
              <p className="text-xs text-muted-foreground font-semibold mb-1">Contact:</p>
              <p className="text-foreground text-xs">1855888248</p>
              <p className="text-muted-foreground text-xs">nagargramservice@gmail.com</p>
              <p className="text-muted-foreground text-xs">www.nagargramservice.com</p>
            </div>
          </div>

          {/* Items Table */}
          <div className="border border-border rounded-lg overflow-hidden mb-6">
            <table className="w-full text-sm">
              <thead>
                <tr className="bg-muted/50">
                  <th className="text-left p-3 text-xs font-semibold text-foreground">SL</th>
                  <th className="text-left p-3 text-xs font-semibold text-foreground">Item Name</th>
                  <th className="text-right p-3 text-xs font-semibold text-foreground">Unit Cost</th>
                  <th className="text-right p-3 text-xs font-semibold text-foreground">Qty</th>
                  <th className="text-right p-3 text-xs font-semibold text-foreground">Amount</th>
                </tr>
              </thead>
              <tbody>
                <tr className="border-t border-border">
                  <td className="p-3 text-muted-foreground">1</td>
                  <td className="p-3 text-foreground">Design Roller</td>
                  <td className="p-3 text-right text-muted-foreground">৳25</td>
                  <td className="p-3 text-right text-muted-foreground">6</td>
                  <td className="p-3 text-right font-medium text-foreground">৳150</td>
                </tr>
                <tr className="border-t border-border">
                  <td className="p-3 text-muted-foreground">2</td>
                  <td className="p-3 text-foreground">Journal Note L</td>
                  <td className="p-3 text-right text-muted-foreground">৳60</td>
                  <td className="p-3 text-right text-muted-foreground">2</td>
                  <td className="p-3 text-right font-medium text-foreground">৳120</td>
                </tr>
                <tr className="border-t border-border">
                  <td className="p-3 text-muted-foreground">3</td>
                  <td className="p-3 text-foreground">Finger Sliper (1 Color)</td>
                  <td className="p-3 text-right text-muted-foreground">৳7</td>
                  <td className="p-3 text-right text-muted-foreground">50</td>
                  <td className="p-3 text-right font-medium text-foreground">৳350</td>
                </tr>
              </tbody>
            </table>
          </div>

          {/* Totals */}
          <div className="flex justify-end mb-6">
            <div className="w-48 space-y-2 text-sm">
              <div className="flex justify-between">
                <span className="text-muted-foreground">Sub Total:</span>
                <span className="text-foreground font-medium">৳620</span>
              </div>
              <div className="flex justify-between">
                <span className="text-muted-foreground">Discount:</span>
                <span className="text-foreground">৳0</span>
              </div>
              <div className="flex justify-between">
                <span className="text-muted-foreground">Tax:</span>
                <span className="text-foreground">৳0</span>
              </div>
              <div className="flex justify-between border-t border-border pt-2">
                <span className="font-bold text-foreground">Total:</span>
                <span className="font-bold text-primary text-lg">৳620</span>
              </div>
            </div>
          </div>

          {/* Footer */}
          <div className="text-center border-t border-border pt-4">
            <p className="text-xs text-muted-foreground italic">
              "Thank you for your purchase. Your support is greatly appreciated."
            </p>
            <div className="mt-3 inline-block bg-success/10 text-success text-xs font-bold px-4 py-1.5 rounded-full">
              PAID
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default InvoicePreview;
