import { getSalesTrend } from "@/data/stockData";
import {
  BarChart,
  Bar,
  XAxis,
  YAxis,
  CartesianGrid,
  Tooltip,
  ResponsiveContainer,
} from "recharts";

const ProfitChart = () => {
  const data = getSalesTrend();

  return (
    <div className="glass-card rounded-xl p-5 animate-fade-in" style={{ animationDelay: "350ms" }}>
      <h3 className="text-lg font-bold font-display text-foreground mb-1">Daily Profit</h3>
      <p className="text-sm text-muted-foreground mb-4">Profit earned per day</p>
      <div className="h-[280px]">
        <ResponsiveContainer width="100%" height="100%">
          <BarChart data={data} margin={{ top: 5, right: 10, left: 0, bottom: 5 }}>
            <CartesianGrid strokeDasharray="3 3" stroke="hsl(145, 20%, 90%)" />
            <XAxis dataKey="date" tick={{ fontSize: 12, fill: "hsl(160, 10%, 45%)" }} />
            <YAxis tick={{ fontSize: 12, fill: "hsl(160, 10%, 45%)" }} />
            <Tooltip
              contentStyle={{
                backgroundColor: "hsl(0, 0%, 100%)",
                border: "1px solid hsl(145, 20%, 90%)",
                borderRadius: "8px",
                boxShadow: "0 4px 12px rgba(0,0,0,0.08)",
              }}
              formatter={(value: number) => [`৳${value.toLocaleString()}`, "Profit"]}
            />
            <Bar dataKey="profit" fill="hsl(152, 60%, 36%)" radius={[6, 6, 0, 0]} barSize={32} />
          </BarChart>
        </ResponsiveContainer>
      </div>
    </div>
  );
};

export default ProfitChart;
