import { stockItems } from "@/data/stockData";
import {
  BarChart,
  Bar,
  XAxis,
  YAxis,
  CartesianGrid,
  Tooltip,
  ResponsiveContainer,
  Legend,
} from "recharts";

const StockOverviewChart = () => {
  const data = stockItems
    .filter(item => item.stockInQty > 0)
    .slice(0, 12)
    .map(item => ({
      name: item.itemName.length > 14 ? item.itemName.slice(0, 14) + "…" : item.itemName,
      stockIn: item.stockInQty,
      sold: item.stockOutQty,
      balance: item.stockBalance,
    }));

  return (
    <div className="glass-card rounded-xl p-5 animate-fade-in" style={{ animationDelay: "300ms" }}>
      <h3 className="text-lg font-bold font-display text-foreground mb-1">Stock Overview</h3>
      <p className="text-sm text-muted-foreground mb-4">Stock In vs Sold vs Remaining Balance</p>
      <div className="h-[320px]">
        <ResponsiveContainer width="100%" height="100%">
          <BarChart data={data} margin={{ top: 5, right: 10, left: 0, bottom: 60 }}>
            <CartesianGrid strokeDasharray="3 3" stroke="hsl(145, 20%, 90%)" />
            <XAxis
              dataKey="name"
              tick={{ fontSize: 10, fill: "hsl(160, 10%, 45%)" }}
              angle={-45}
              textAnchor="end"
              height={80}
            />
            <YAxis tick={{ fontSize: 12, fill: "hsl(160, 10%, 45%)" }} />
            <Tooltip
              contentStyle={{
                backgroundColor: "hsl(0, 0%, 100%)",
                border: "1px solid hsl(145, 20%, 90%)",
                borderRadius: "8px",
                boxShadow: "0 4px 12px rgba(0,0,0,0.08)",
              }}
            />
            <Legend wrapperStyle={{ fontSize: 12, paddingTop: 8 }} />
            <Bar dataKey="stockIn" name="Stock In" fill="hsl(152, 60%, 36%)" radius={[4, 4, 0, 0]} barSize={14} />
            <Bar dataKey="sold" name="Sold" fill="hsl(152, 45%, 55%)" radius={[4, 4, 0, 0]} barSize={14} />
            <Bar dataKey="balance" name="Balance" fill="hsl(145, 50%, 80%)" radius={[4, 4, 0, 0]} barSize={14} />
          </BarChart>
        </ResponsiveContainer>
      </div>
    </div>
  );
};

export default StockOverviewChart;
